# difference in D-score for control / intervention
t.test(part_control$d_result, part_interv_all$d_result)
t.test(part_control$d_result, part_interv_female$d_result)
t.test(part_control$d_result, part_interv_male$d_result)
t.test(part_interv_all$d_result, part_interv_female$d_result)
t.test(part_interv_all$d_result, part_interv_male$d_result)
t.test(part_interv_female$d_result, part_interv_male$d_result)

mean(part_control$d_result)
mean(part_interv_all$d_result)
mean(part_interv_female$d_result)
mean(part_interv_male$d_result)

# gender
## within groups boys vs girls
participants_jongen <- subset(part_control, part_control$gender=="Jongen")
participants_meisje <- subset(part_control, part_control$gender=="Meisje")
t.test(participants_jongen$d_result, participants_meisje$d_result)

mean(participants_jongen$d_result)
mean(participants_meisje$d_result)

participants_jongen <- subset(part_interv_all, part_interv_all$gender=="Jongen")
participants_meisje <- subset(part_interv_all, part_interv_all$gender=="Meisje")
t.test(participants_jongen$d_result, participants_meisje$d_result)

mean(participants_jongen$d_result)
mean(participants_meisje$d_result)

participants_jongen <- subset(part_interv_female, part_interv_female$gender=="Jongen")
participants_meisje <- subset(part_interv_female, part_interv_female$gender=="Meisje")
t.test(participants_jongen$d_result, participants_meisje$d_result)

mean(participants_jongen$d_result)
mean(participants_meisje$d_result)

participants_jongen <- subset(part_interv_male, part_interv_male$gender=="Jongen")
participants_meisje <- subset(part_interv_male, part_interv_male$gender=="Meisje")
t.test(participants_jongen$d_result, participants_meisje$d_result)

mean(participants_jongen$d_result)
mean(participants_meisje$d_result)

rm(participants_meisje, participants_jongen)

## between group
part_control_gender <- subset(part_control, part_control$gender=="Jongen")
part_all_gender <- subset(part_interv_all, part_interv_all$gender=="Jongen")
part_interv_female_gender <- subset(part_interv_female, part_interv_female$gender=="Jongen")
part_interv_male_gender <- subset(part_interv_male, part_interv_male$gender=="Jongen")

t.test(part_control_gender$d_result, part_all_gender$d_result)
t.test(part_control_gender$d_result, part_interv_female_gender$d_result)
t.test(part_control_gender$d_result, part_interv_male_gender$d_result)
t.test(part_all_gender$d_result, part_interv_female_gender$d_result)
t.test(part_all_gender$d_result, part_interv_male_gender$d_result)
t.test(part_interv_female_gender$d_result, part_interv_male_gender$d_result)

part_control_gender <- subset(part_control, part_control$gender=="Meisje")
part_all_gender <- subset(part_interv_all, part_interv_all$gender=="Meisje")
part_interv_female_gender <- subset(part_interv_female, part_interv_female$gender=="Meisje")
part_interv_male_gender <- subset(part_interv_male, part_interv_male$gender=="Meisje")

t.test(part_control_gender$d_result, part_all_gender$d_result)
t.test(part_control_gender$d_result, part_interv_female_gender$d_result)
t.test(part_control_gender$d_result, part_interv_male_gender$d_result)
t.test(part_all_gender$d_result, part_interv_female_gender$d_result)
t.test(part_all_gender$d_result, part_interv_male_gender$d_result)
t.test(part_interv_female_gender$d_result, part_interv_male_gender$d_result)

rm(part_control_gender, part_all_gender, part_interv_female_gender, part_interv_male_gender)

# age 
## in group
cor.test(part_control$d_result, part_control$age)
cor.test(part_interv_all$d_result, part_interv_all$age)
cor.test(part_interv_female$d_result, part_interv_female$age)
cor.test(part_interv_male$d_result, part_interv_male$age)

cor.test(part_control$d_result, part_control$age_category)
cor.test(part_interv_all$d_result, part_interv_all$age_category)
cor.test(part_interv_female$d_result, part_interv_female$age_category)
cor.test(part_interv_male$d_result, part_interv_male$age_category)

#control
part_control_po <- subset(part_control, part_control$age_category==1)
part_control_mix <- subset(part_control, part_control$age_category==2)
part_control_vo <- subset(part_control, part_control$age_category==3)

t.test(part_control_po$d_result, part_control_mix$d_result)
t.test(part_control_po$d_result, part_control_vo$d_result)
t.test(part_control_vo$d_result, part_control_mix$d_result)

#interv all
part_interv_all_po <- subset(part_interv_all, part_interv_all$age_category==1)
part_interv_all_mix <- subset(part_interv_all, part_interv_all$age_category==2)
part_interv_all_vo <- subset(part_interv_all, part_interv_all$age_category==3)

t.test(part_interv_all_po$d_result, part_interv_all_mix$d_result)
t.test(part_interv_all_po$d_result, part_interv_all_vo$d_result)
t.test(part_interv_all_vo$d_result, part_interv_all_mix$d_result)

#interv female
part_interv_female_po <- subset(part_interv_female, part_interv_female$age_category==1)
part_interv_female_mix <- subset(part_interv_female, part_interv_female$age_category==2)
part_interv_female_vo <- subset(part_interv_female, part_interv_female$age_category==3)

t.test(part_interv_female_po$d_result, part_interv_female_mix$d_result)
t.test(part_interv_female_po$d_result, part_interv_female_vo$d_result)
t.test(part_interv_female_vo$d_result, part_interv_female_mix$d_result)

#interv male
part_interv_male_po <- subset(part_interv_male, part_interv_male$age_category==1)
part_interv_male_mix <- subset(part_interv_male, part_interv_male$age_category==2)
part_interv_male_vo <- subset(part_interv_male, part_interv_male$age_category==3)

t.test(part_interv_male_po$d_result, part_interv_male_mix$d_result)
t.test(part_interv_male_po$d_result, part_interv_male_vo$d_result)
t.test(part_interv_male_vo$d_result, part_interv_male_mix$d_result)

## between group
#cat po
t.test(part_control_po$d_result, part_interv_all_po$d_result)
t.test(part_control_po$d_result, part_interv_female_po$d_result)
t.test(part_control_po$d_result, part_interv_male_po$d_result)
t.test(part_interv_all_po$d_result, part_interv_female_po$d_result)
t.test(part_interv_all_po$d_result, part_interv_male_po$d_result)
t.test(part_interv_female_po$d_result, part_interv_male_po$d_result)

#cat mix
t.test(part_control_mix$d_result, part_interv_all_mix$d_result)
t.test(part_control_mix$d_result, part_interv_female_mix$d_result)
t.test(part_control_mix$d_result, part_interv_male_mix$d_result)
t.test(part_interv_all_mix$d_result, part_interv_female_mix$d_result)
t.test(part_interv_all_mix$d_result, part_interv_male_mix$d_result)
t.test(part_interv_female_mix$d_result, part_interv_male_mix$d_result)

#cat vo
t.test(part_control_vo$d_result, part_interv_all_vo$d_result)
t.test(part_control_vo$d_result, part_interv_female_vo$d_result)
t.test(part_control_vo$d_result, part_interv_male_vo$d_result)
t.test(part_interv_all_vo$d_result, part_interv_female_vo$d_result)
t.test(part_interv_all_vo$d_result, part_interv_male_vo$d_result)
t.test(part_interv_female_vo$d_result, part_interv_male_vo$d_result)

rm(part_control_po, part_control_mix, part_control_vo)
rm(part_interv_all_po, part_interv_all_mix, part_interv_all_vo)
rm(part_interv_female_po, part_interv_female_mix, part_interv_female_vo)
rm(part_interv_male_po, part_interv_male_mix, part_interv_male_vo)

# experience 
## within
participants_subset <- part_control 
control_experienced <- participants_experience(participants_subset, "Yes")
control_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
control_experienced_home <- participants_experience(participants_subset, "Yes-home")
control_experienced_school <- participants_experience(participants_subset, "Yes-school")
control_not_experienced <- participants_experience(participants_subset, "No")

t.test(control_experienced$d_result, control_not_experienced$d_result)
t.test(control_experienced$d_result, control_experienced_libary_codeclub$d_result)
t.test(control_experienced$d_result, control_experienced_home$d_result)
t.test(control_experienced$d_result, control_experienced_school$d_result)
t.test(control_experienced_libary_codeclub$d_result, control_experienced_home$d_result)
t.test(control_experienced_libary_codeclub$d_result, control_experienced_school$d_result)
t.test(control_experienced_libary_codeclub$d_result, control_not_experienced$d_result)
t.test(control_experienced_home$d_result, control_experienced_school$d_result)
t.test(control_experienced_home$d_result, control_not_experienced$d_result)
t.test(control_experienced_school$d_result, control_not_experienced$d_result)

participants_subset <- part_interv_all
interv_experienced <- participants_experience(participants_subset, "Yes")
interv_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
interv_experienced_home <- participants_experience(participants_subset, "Yes-home")
interv_experienced_school <- participants_experience(participants_subset, "Yes-school")
interv_not_experienced <- participants_experience(participants_subset, "No")

t.test(interv_experienced$d_result, interv_not_experienced$d_result)
t.test(interv_experienced$d_result, interv_experienced_libary_codeclub$d_result)
t.test(interv_experienced$d_result, interv_experienced_home$d_result)
t.test(interv_experienced$d_result, interv_experienced_school$d_result)
t.test(interv_experienced_libary_codeclub$d_result, interv_experienced_home$d_result)
t.test(interv_experienced_libary_codeclub$d_result, interv_experienced_school$d_result)
t.test(interv_experienced_libary_codeclub$d_result, interv_not_experienced$d_result)
t.test(interv_experienced_home$d_result, interv_experienced_school$d_result)
t.test(interv_experienced_home$d_result, interv_not_experienced$d_result)
t.test(interv_experienced_school$d_result, interv_not_experienced$d_result)

participants_subset <- part_interv_female 
interv_female_experienced <- participants_experience(participants_subset, "Yes")
interv_female_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
interv_female_experienced_home <- participants_experience(participants_subset, "Yes-home")
interv_female_experienced_school <- participants_experience(participants_subset, "Yes-school")
interv_female_not_experienced <- participants_experience(participants_subset, "No")

t.test(interv_female_experienced$d_result, interv_female_not_experienced$d_result)
t.test(interv_female_experienced$d_result, interv_female_experienced_libary_codeclub$d_result)
t.test(interv_female_experienced$d_result, interv_female_experienced_home$d_result)
t.test(interv_female_experienced$d_result, interv_female_experienced_school$d_result)
t.test(interv_female_experienced_libary_codeclub$d_result, interv_female_experienced_home$d_result)
t.test(interv_female_experienced_libary_codeclub$d_result, interv_female_experienced_school$d_result)
t.test(interv_female_experienced_libary_codeclub$d_result, interv_female_not_experienced$d_result)
t.test(interv_female_experienced_home$d_result, interv_female_experienced_school$d_result)
t.test(interv_female_experienced_home$d_result, interv_female_not_experienced$d_result)
t.test(interv_female_experienced_school$d_result, interv_female_not_experienced$d_result)

participants_subset <- part_interv_male 
interv_male_experienced <- participants_experience(participants_subset, "Yes")
interv_male_experienced_libary_codeclub <- participants_experience(participants_subset, "Yes-outofschool")
interv_male_experienced_home <- participants_experience(participants_subset, "Yes-home")
interv_male_experienced_school <- participants_experience(participants_subset, "Yes-school")
interv_male_not_experienced <- participants_experience(participants_subset, "No")

t.test(interv_male_experienced$d_result, interv_male_not_experienced$d_result)
t.test(interv_male_experienced$d_result, interv_male_experienced_libary_codeclub$d_result)
t.test(interv_male_experienced$d_result, interv_male_experienced_home$d_result)
t.test(interv_male_experienced$d_result, interv_male_experienced_school$d_result)
t.test(interv_male_experienced_libary_codeclub$d_result, interv_male_experienced_home$d_result)
t.test(interv_male_experienced_libary_codeclub$d_result, interv_male_experienced_school$d_result)
t.test(interv_male_experienced_libary_codeclub$d_result, interv_male_not_experienced$d_result)
t.test(interv_male_experienced_home$d_result, interv_male_experienced_school$d_result)
t.test(interv_male_experienced_home$d_result, interv_male_not_experienced$d_result)
t.test(interv_male_experienced_school$d_result, interv_male_not_experienced$d_result)

#between
#experienced
t.test(control_experienced$d_result, interv_experienced$d_result)
t.test(control_experienced$d_result, interv_female_experienced$d_result)
t.test(control_experienced$d_result, interv_male_experienced$d_result)
t.test(interv_experienced$d_result, interv_female_experienced$d_result)
t.test(interv_experienced$d_result, interv_male_experienced$d_result)
t.test(interv_female_experienced$d_result, interv_male_experienced$d_result)

#not experienced
t.test(control_not_experienced$d_result, interv_not_experienced$d_result)
t.test(control_not_experienced$d_result, interv_female_not_experienced$d_result)
t.test(control_not_experienced$d_result, interv_male_not_experienced$d_result)
t.test(interv_not_experienced$d_result, interv_female_not_experienced$d_result)
t.test(interv_not_experienced$d_result, interv_male_not_experienced$d_result)
t.test(interv_female_not_experienced$d_result, interv_male_not_experienced$d_result)

#out of school
t.test(control_experienced_libary_codeclub$d_result, interv_experienced_libary_codeclub$d_result)
t.test(control_experienced_libary_codeclub$d_result, interv_female_experienced_libary_codeclub$d_result)
t.test(control_experienced_libary_codeclub$d_result, interv_male_experienced_libary_codeclub$d_result)
t.test(interv_experienced_libary_codeclub$d_result, interv_female_experienced_libary_codeclub$d_result)
t.test(interv_experienced_libary_codeclub$d_result, interv_male_experienced_libary_codeclub$d_result)
t.test(interv_female_experienced_libary_codeclub$d_result, interv_male_experienced_libary_codeclub$d_result)

#school
t.test(control_experienced_school$d_result, interv_experienced_school$d_result)
t.test(control_experienced_school$d_result, interv_female_experienced_school$d_result)
t.test(control_experienced_school$d_result, interv_male_experienced_school$d_result)
t.test(interv_experienced_school$d_result, interv_female_experienced_school$d_result)
t.test(interv_experienced_school$d_result, interv_male_experienced_school$d_result)
t.test(interv_female_experienced_school$d_result, interv_male_experienced_school$d_result)

#home
t.test(control_experienced_home$d_result, interv_experienced_home$d_result)
t.test(control_experienced_home$d_result, interv_female_experienced_home$d_result)
t.test(control_experienced_home$d_result, interv_male_experienced_home$d_result)
t.test(interv_experienced_home$d_result, interv_female_experienced_home$d_result)
t.test(interv_experienced_home$d_result, interv_male_experienced_home$d_result)
t.test(interv_female_experienced_home$d_result, interv_male_experienced_home$d_result)

rm(control_experienced, control_not_experienced, control_experienced_libary_codeclub, control_experienced_home, control_experienced_school)

# familiar
participants_subset <- part_control
control_familiar <- participants_familiar(participants_subset, "Yes")
control_familiar_often <- participants_familiar(participants_subset, "Yes-often")
control_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
control_familiar_media <- participants_familiar(participants_subset, "Yes-media")
control_not_familiar <- participants_familiar(participants_subset, "No")

t.test(control_familiar$d_result, control_not_familiar$d_result)
t.test(control_familiar$d_result, control_familiar_often$d_result)
t.test(control_familiar$d_result, control_familiar_not_often$d_result)
t.test(control_familiar$d_result, control_familiar_media$d_result)
t.test(control_familiar_often$d_result, control_familiar_not_often$d_result)
t.test(control_familiar_often$d_result, control_familiar_media$d_result)
t.test(control_familiar_often$d_result, control_not_familiar$d_result)
t.test(control_familiar_not_often$d_result, control_familiar_media$d_result)
t.test(control_familiar_not_often$d_result, control_not_familiar$d_result)
t.test(control_familiar_media$d_result, control_not_familiar$d_result)

participants_subset <- part_interv_all
interv_familiar <- participants_familiar(participants_subset, "Yes")
interv_familiar_often <- participants_familiar(participants_subset, "Yes-often")
interv_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
interv_familiar_media <- participants_familiar(participants_subset, "Yes-media")
interv_not_familiar <- participants_familiar(participants_subset, "No")

t.test(interv_familiar$d_result, interv_not_familiar$d_result)
t.test(interv_familiar$d_result, interv_familiar_often$d_result)
t.test(interv_familiar$d_result, interv_familiar_not_often$d_result)
t.test(interv_familiar$d_result, interv_familiar_media$d_result)
t.test(interv_familiar_often$d_result, interv_familiar_not_often$d_result)
t.test(interv_familiar_often$d_result, interv_familiar_media$d_result)
t.test(interv_familiar_often$d_result, interv_not_familiar$d_result)
t.test(interv_familiar_not_often$d_result, interv_familiar_media$d_result)
t.test(interv_familiar_not_often$d_result, interv_not_familiar$d_result)
t.test(interv_familiar_media$d_result, interv_not_familiar$d_result)

participants_subset <- part_interv_female
interv_female_familiar <- participants_familiar(participants_subset, "Yes")
interv_female_familiar_often <- participants_familiar(participants_subset, "Yes-often")
interv_female_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
interv_female_familiar_media <- participants_familiar(participants_subset, "Yes-media")
interv_female_not_familiar <- participants_familiar(participants_subset, "No")

t.test(interv_female_familiar$d_result, interv_female_not_familiar$d_result)
t.test(interv_female_familiar$d_result, interv_female_familiar_often$d_result)
t.test(interv_female_familiar$d_result, interv_female_familiar_not_often$d_result)
t.test(interv_female_familiar$d_result, interv_female_familiar_media$d_result)
t.test(interv_female_familiar_often$d_result, interv_female_familiar_not_often$d_result)
t.test(interv_female_familiar_often$d_result, interv_female_familiar_media$d_result)
t.test(interv_female_familiar_often$d_result, interv_female_not_familiar$d_result)
t.test(interv_female_familiar_not_often$d_result, interv_female_familiar_media$d_result)
t.test(interv_female_familiar_not_often$d_result, interv_female_not_familiar$d_result)
t.test(interv_female_familiar_media$d_result, interv_female_not_familiar$d_result)

participants_subset <- part_interv_male
interv_male_familiar <- participants_familiar(participants_subset, "Yes")
interv_male_familiar_often <- participants_familiar(participants_subset, "Yes-often")
interv_male_familiar_not_often <- participants_familiar(participants_subset, "Yes-not-often")
interv_male_familiar_media <- participants_familiar(participants_subset, "Yes-media")
interv_male_not_familiar <- participants_familiar(participants_subset, "No")

t.test(interv_male_familiar$d_result, interv_male_not_familiar$d_result)
t.test(interv_male_familiar$d_result, interv_male_familiar_often$d_result)
t.test(interv_male_familiar$d_result, interv_male_familiar_not_often$d_result)
t.test(interv_male_familiar$d_result, interv_male_familiar_media$d_result)
t.test(interv_male_familiar_often$d_result, interv_male_familiar_not_often$d_result)
t.test(interv_male_familiar_often$d_result, interv_male_familiar_media$d_result)
t.test(interv_male_familiar_often$d_result, interv_male_not_familiar$d_result)
t.test(interv_male_familiar_not_often$d_result, interv_male_familiar_media$d_result)
t.test(interv_male_familiar_not_often$d_result, interv_male_not_familiar$d_result)
t.test(interv_male_familiar_media$d_result, interv_male_not_familiar$d_result)

#between
#Yes
t.test(control_familiar$d_result, interv_familiar$d_result)
t.test(control_familiar$d_result, interv_female_familiar$d_result)
t.test(control_familiar$d_result, interv_male_familiar$d_result)
t.test(interv_familiar$d_result, interv_female_familiar$d_result)
t.test(interv_familiar$d_result, interv_male_familiar$d_result)
t.test(interv_female_familiar$d_result, interv_male_familiar$d_result)

#No
t.test(control_not_familiar$d_result, interv_not_familiar$d_result)
t.test(control_not_familiar$d_result, interv_female_not_familiar$d_result)
t.test(control_not_familiar$d_result, interv_male_not_familiar$d_result)
t.test(interv_not_familiar$d_result, interv_female_not_familiar$d_result)
t.test(interv_not_familiar$d_result, interv_male_not_familiar$d_result)
t.test(interv_female_not_familiar$d_result, interv_male_not_familiar$d_result)

#Yes - often
t.test(control_familiar_often$d_result, interv_familiar_often$d_result)
t.test(control_familiar_often$d_result, interv_female_familiar_often$d_result)
t.test(control_familiar_often$d_result, interv_male_familiar_often$d_result)
t.test(interv_familiar_often$d_result, interv_female_familiar_often$d_result)
t.test(interv_familiar_often$d_result, interv_male_familiar_often$d_result)
t.test(interv_female_familiar_often$d_result, interv_male_familiar_often$d_result)

#Yes - not often
t.test(control_familiar_not_often$d_result, interv_familiar_not_often$d_result)
t.test(control_familiar_not_often$d_result, interv_female_familiar_not_often$d_result)
t.test(control_familiar_not_often$d_result, interv_male_familiar_not_often$d_result)
t.test(interv_familiar_not_often$d_result, interv_female_familiar_not_often$d_result)
t.test(interv_familiar_not_often$d_result, interv_male_familiar_not_often$d_result)
t.test(interv_female_familiar_not_often$d_result, interv_male_familiar_not_often$d_result)

#Yes - media
t.test(control_familiar_media$d_result, interv_familiar_media$d_result)
t.test(control_familiar_media$d_result, interv_female_familiar_media$d_result)
t.test(control_familiar_media$d_result, interv_male_familiar_media$d_result)
t.test(interv_familiar_media$d_result, interv_female_familiar_media$d_result)
t.test(interv_familiar_media$d_result, interv_male_familiar_media$d_result)
t.test(interv_female_familiar_media$d_result, interv_male_familiar_media$d_result)

