library(ggplot2)

participants_gender <- function(participants, gender){
  if (gender == "Jongen") {
    subset_gender = subset(participants, participants$gender == "Jongen")
  } 
  if (gender == "Meisje") {
    subset_gender = subset(participants, participants$gender == "Meisje")
  }
  
  return(subset_gender)
}

participants_experience <- function(participants, experience){
  if (experience == "No") {
    subset_experience = subset(participants, participants$experience == "{Nee}"
                               | grepl("Ik weet niet wat programmeren is",participants$experience)
    )
  } 
  if (experience == "Yes" | experience == "Yes-school" | experience == "Yes-home" | experience == "Yes-outofschool") {
    subset_experience = subset(participants, participants$experience != "{Nee}"
                               & participants$experience != "{Ik weet niet wat programmeren is}"
                               & participants$experience != "{Nee,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op school,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op school,Nee,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub,Ja, bij familie, vrienden of thuis,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op school,Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub,Ja, bij familie, vrienden of thuis,Ik weet niet wat programmeren is}"
    )
  }
  if (experience == "Yes-school") {
    subset_experience = subset(subset_experience, grepl("Ja, op school",subset_experience$experience))
  } 
  if (experience == "Yes-home") {
    subset_experience = subset(subset_experience, grepl("Ja, bij familie, vrienden of thuis",subset_experience$experience))
  } 
  if (experience == "Yes-outofschool") {
    subset_experience = subset(subset_experience, grepl("Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub",subset_experience$experience))
  } 
  
  return(subset_experience)
}

participants_familiar <- function(participants, familiar){
  if (familiar == "No") {
    subset_familiar = subset(participants, participants$familiar == "{Nee}"
                             | grepl("Weet ik niet",participants$familiar)
    )
  } 
  if (familiar == "Yes" | familiar == "Yes-often" | familiar == "Yes-not-often" | familiar == "Yes-media") {
    subset_familiar = subset(participants, participants$familiar != "{Nee}"
                             & participants$familiar != "{Weet ik niet}"
                             & participants$familiar != "{Nee,Weet ik niet}"
                             & participants$familiar != "{Ja, maar ik zie deze persoon niet vaak,Weet ik niet}"
                             & participants$familiar != "{Ja, iemand die ik vaak zie is programmeur,Ja, van een film, serie of tv,Weet ik niet}"
    )
  }   
  if (familiar == "Yes-often") {
    subset_familiar = subset(subset_familiar, grepl("Ja, iemand die ik vaak zie is programmeur",subset_familiar$familiar))
  } 
  if (familiar == "Yes-not-often") {
    subset_familiar = subset(subset_familiar, grepl("Ja, maar ik zie deze persoon niet vaak",subset_familiar$familiar))
  } 
  if (familiar == "Yes-media") {
    subset_familiar = subset(subset_familiar, grepl("Ja, van een film, serie of tv",subset_familiar$familiar))
  } 
  
  return(subset_familiar)
}

answers_on_question_id <- function(question_nmr, answer_dataset){
  subset_question = subset(answer_dataset, answer_dataset$question_id == question_nmr)
  return(subset_question)
}

answers_gender <- function(participants, answers, gender){
  
  subset_gender <- participants_gender(participants, gender)
  
  answers_subset <- answers[is.element(answers$participant_id, subset_gender$id),]
  answers_subset$X. <- NULL
  
  return(answers_subset)
}

answers_social <- function(answer, social, threshold){
  
  if(social){
    subset <- subset(answer, answer$question_id==1 & answer$answers<=threshold)
  } else { 
    subset <- subset(answer, answer$question_id==1 & answer$answers>threshold)
  }
  
  return(subset)
}

answers_experience <- function(participants, answers, experience){
  subset_experience <- participants_experience(participants, experience)
  answers_subset <- answers[is.element(answers$participant_id, subset_experience$id),]
  answers_subset$X. <- NULL
  
  return(answers_subset)
}

answers_familiar <- function(participants, answers, familiar){
  subset_familiar <- participants_familiar(participants, familiar)
  answers_subset <- answers[is.element(answers$participant_id, subset_familiar$id),]
  answers_subset$X. <- NULL
  
  return(answers_subset)
}

merge_answers_specific_question_participants <- function(question_nmr, participants, answers){
  answers_specific_question = answers_on_question_id(nmr, answers)
  merged_answers_participants <- merge(answers_specific_question, participants, by.x = "participant_id", by.y = "id")
  return(merged_answers_participants)
}

numbers_on_eit <- function(question_nmr, answers){
  
  subset_question <- answers_on_question_id(question_nmr, answers)
  
  print(paste('mean on question', question_nmr, ':', mean(as.numeric(subset_question$answers))))
  print(paste('median on question', question_nmr, ':', median(as.numeric(subset_question$answers))))

  questionHistogram <- ggplot(subset_question, aes(answers)) + 
    geom_histogram(binwidth = 1, colour='grey', fill='gray88') + 
    scale_x_continuous(breaks = seq(0, 6, 1)) +
    theme_void() + 
    theme(axis.title.x = element_blank(), axis.text.x=element_blank(), axis.ticks.x=element_blank(), axis.text.y=element_blank(), axis.ticks.y=element_blank(), axis.title.y = element_blank() ) 
  
  plot(questionHistogram)
}

numbers_on_eit_gender <- function(question_nmr, participants, answers, gender){
  subset <- answers_gender(participants, answers, gender)
  numbers_on_eit(question_nmr, subset)
}

t_test_on_question_id <- function(question_nmr, answers1, answers2){
  subset_1_question <- answers_on_question_id(question_nmr, answers1)
  subset_2_question <- answers_on_question_id(question_nmr, answers2)
  
  t.test(subset_1_question$answers, subset_2_question$answers)
}

effect_size_on_question_id <- function(question_nmr, answers1, answers2){
  subset_1_question <- answers_on_question_id(question_nmr, answers1)
  subset_2_question <- answers_on_question_id(question_nmr, answers2)
  
  cohen.d(subset_1_question$answers, subset_2_question$answers)
}

effect_boys_vs_girls_on_question_id <- function(question_nmr, participants, answers){
  participants_boys <- answers_gender(participants, answers, "Jongen")
  participants_girls <- answers_gender(participants, answers, "Meisje")
  
  effect_size_on_question_id(nmr, participants_boys, participants_girls)
}

t_test_boys_vs_girls_on_question_id <- function(question_nmr, participants, answers){
  participants_boys <- answers_gender(participants, answers, "Jongen")
  participants_girls <- answers_gender(participants, answers, "Meisje")
  
  t_test_on_question_id(nmr, participants_boys, participants_girls)
}

t_test_social_vs_asocial_on_question_id <- function(question_nmr, participants, answers, threshold){
  participants_social <- answers_social(participants, answers, TRUE, threshold)
  participants_asocial <- answers_social(participants, answers, FALSE, threshold)
  
  t_test_on_question_id(nmr, participants_social, participants_asocial)
}

effect_size_gender_on_question_id <- function(nmr, participants1, answers1, gender1, participants2, answers2, gender2){
  participant_subset1 <- answers_gender(participants1, answers1, gender1)
  participant_subset2 <- answers_gender(participants2, answers2, gender2)
  
  effect_size_on_question_id(nmr, participant_subset1, participant_subset2)
}

t_test_gender_on_question_id <- function(nmr, participants1, answers1, gender1, participants2, answers2, gender2){
  participant_subset1 <- answers_gender(participants1, answers1, gender1)
  participant_subset2 <- answers_gender(participants2, answers2, gender2)
  
  t_test_on_question_id(nmr, participant_subset1, participant_subset2)
}

t_test_experience_on_question_id <- function(question_nmr, participants, answers, condition1, condition2){
  answers_1 <- answers_experience(participants, answers, condition1)
  answers_2 <- answers_experience(participants, answers, condition2)
  
  t_test_on_question_id(nmr, answers_1, answers_2)
}

t_test_familiar_on_question_id <- function(question_nmr, participants, answers, condition1, condition2){
  answers_1 <- answers_familiar(participants, answers, condition1)
  answers_2 <- answers_familiar(participants, answers, condition2)
  
  t_test_on_question_id(nmr, answers_1, answers_2)
}

effect_familiar_on_question_id <- function(question_nmr, participants, answers, condition1, condition2){
  answers_1 <- answers_familiar(participants, answers, condition1)
  answers_2 <- answers_familiar(participants, answers, condition2)
  
  effect_size_on_question_id(nmr, answers_1, answers_2)
}


t_test_gender_age_on_question_id <- function(question_nmr, participants1, answers1, age1, gender1, 
                                                        participants2, answers2, age2, gender2){
  
  subset_participants1 <- subset(participants1, participants1$age == age1 & participants1$gender == gender1)
  subset_participants2 <- subset(participants2, participants2$age == age2 & participants2$gender == gender2)
  
  subset_answers1 <- answers1[is.element(answers1$participant_id, subset_participants1$id),]
  subset_answers1$X. <- NULL
  
  subset_answers2 <- answers2[is.element(answers2$participant_id, subset_participants2$id),]
  subset_answers2$X. <- NULL
  
  merged1 <- merge_answers_specific_question_participants(question_nmr, subset_participants1, subset_answers1)
  merged2 <- merge_answers_specific_question_participants(question_nmr, subset_participants2, subset_answers2)
  
  t_test_on_question_id(nmr, merged1, merged2)
}

t_test_boys_vs_girls_experience_on_question_id <- function(question_nmr, participants, answers, experience){
  
  boys <- participants_gender(participants, "Jongen")
  girls <- participants_gender(participants, "Meisje")
  
  answers_experience_boys <- answers_experience_question(boys, answers, experience)
  answers_experience_girls <- answers_experience_question(girls, answers, experience)
  
  t_test_on_question_id(nmr, answers_experience_boys, answers_experience_girls)
}
