library(ggplot2)

getmode <- function(v) {
  uniqv <- unique(v)
  uniqv[which.max(tabulate(match(v, uniqv)))]
}

### Stereotypes
## implicit gender
sum(!is.na(participants_control$gender_d))
mean(participants_control$gender_d)
median(participants_control$gender_d)
sd(participants_control$gender_d)
cor.test(participants_control$gender_d, participants_control$q5, method = "spearman")

# gender
cor.test(participants_girls$gender_d, participants_girls$q5, method = "spearman")
cor.test(participants_boys$gender_d, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$gender_d, participants_control$age)
cor.test(participants_control$gender_d, participants_control$age_category)
cor.test(participants_age_7_8$gender_d, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$gender_d, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$gender_d, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$gender_d, participants_age_13_14$q5, method = "spearman")

## implicit social
sum(!is.na(participants_control$social_d))
mean(participants_control$social_d, na.rm = TRUE)
median(participants_control$social_d, na.rm = TRUE)
sd(participants_control$social_d, na.rm = TRUE)
cor.test(participants_control$social_d, participants_control$q5, method = "spearman")

# gender
cor.test(participants_girls$social_d, participants_girls$q5, method = "spearman")
cor.test(participants_boys$social_d, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$social_d, participants_control$age)
cor.test(participants_control$social_d, participants_control$age_category)
cor.test(participants_age_7_8$social_d, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$social_d, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$social_d, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$social_d, participants_age_13_14$q5, method = "spearman")

cor.test(participants_age_7_8$social_d, participants_age_7_8$q5, method = "spearman")
subset_q5_1 = subset(participants_age_7_8, participants_age_7_8$q5 == 1)
subset_q5_2 = subset(participants_age_7_8, participants_age_7_8$q5 == 2)
subset_q5_3 = subset(participants_age_7_8, participants_age_7_8$q5 == 3)
subset_q5_4 = subset(participants_age_7_8, participants_age_7_8$q5 == 4)
subset_q5_5 = subset(participants_age_7_8, participants_age_7_8$q5 == 5)

mean(subset_q5_1$social_d, na.rm = TRUE)
mean(subset_q5_2$social_d, na.rm = TRUE)
mean(subset_q5_3$social_d, na.rm = TRUE)
mean(subset_q5_4$social_d, na.rm = TRUE)
mean(subset_q5_5$social_d, na.rm = TRUE)

## implicit interests
sum(!is.na(participants_control$interests_d))
mean(participants_control$interests_d, na.rm = TRUE)
median(participants_control$interests_d, na.rm = TRUE)
sd(participants_control$interests_d, na.rm = TRUE)
cor.test(participants_control$interests_d, participants_control$q5, method = "spearman")

# gender
cor.test(participants_girls$interests_d, participants_girls$q5, method = "spearman")
cor.test(participants_boys$interests_d, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$interests_d, participants_control$age)
cor.test(participants_age_7_8$interests_d, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$interests_d, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$interests_d, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$interests_d, participants_age_13_14$q5, method = "spearman")

## explicit gender (q9 - q10 - q13)
# 9	- Welk beroep vind jij iets voor meisjes?

table(participants_control$q9)
getmode(participants_control$q9)
median(participants_control$q9)
cor.test(participants_control$q9, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q9)
table(participants_boys$q9)

cor.test(participants_girls$q9, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q9, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q9, participants_control$age)
cor.test(participants_control$q9, participants_control$age_category)
cor.test(participants_age_7_8$q9, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q9, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q9, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q9, participants_age_13_14$q5, method = "spearman")

# 10	Welk beroep vind jij iets voor jongens?

table(participants_control$q10)
getmode(participants_control$q10)
median(participants_control$q10)
cor.test(participants_control$q10, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q10)
table(participants_boys$q10)

cor.test(participants_girls$q10, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q10, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q10, participants_control$age)
cor.test(participants_age_7_8$q10, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q10, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q10, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q10, participants_age_13_14$q5, method = "spearman")

# 13	Programmeur zijn, dat is een beroep voor
table(participants_control$q13)
getmode(participants_control$q13)
median(participants_control$q13)
cor.test(participants_control$q13, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q13)
table(participants_boys$q13)
cor.test(participants_girls$q13, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q13, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q13, participants_control$age)
cor.test(participants_age_7_8$q13, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q13, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q13, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q13, participants_age_13_14$q5, method = "spearman")

# social-explicit (q6 - q11)
# 6	Wie maakt het makkelijkst vrienden en werkt het liefst samen?
table(participants_control$q6)
getmode(participants_control$q6)
median(participants_control$q6)
cor.test(participants_control$q6, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q6)
table(participants_boys$q6)
cor.test(participants_girls$q6, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q6, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q6, participants_control$age)
cor.test(participants_age_7_8$q6, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q6, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q6, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q6, participants_age_13_14$q5, method = "spearman")

# 11	Programmeurs maken makkelijk vrienden en werken graag samen.
table(participants_control$q11)
getmode(participants_control$q11)
median(participants_control$q11)
cor.test(participants_control$q11, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q11)
table(participants_boys$q11)
cor.test(participants_girls$q11, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q11, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q11, participants_control$age)
cor.test(participants_age_7_8$q11, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q11, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q11, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q11, participants_age_13_14$q5, method = "spearman")

# interests-explicit (q7 - q8 - q12)
# 7	Wie speelt er het liefste videospelletjes?
table(participants_control$q7)
getmode(participants_control$q7)
median(participants_control$q7)
cor.test(participants_control$q7, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q7)
table(participants_boys$q7)
cor.test(participants_girls$q7, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q7, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q7, participants_control$age)
cor.test(participants_age_7_8$q7, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q7, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q7, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q7, participants_age_13_14$q5, method = "spearman")

# 8	Wie speelt er het liefste tennis?
table(participants_control$q8)
getmode(participants_control$q8)
median(participants_control$q8)
cor.test(participants_control$q8, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q8)
table(participants_boys$q8)
cor.test(participants_girls$q8, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q8, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q8, participants_control$age)
cor.test(participants_age_7_8$q8, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q8, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q8, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q8, participants_age_13_14$q5, method = "spearman")

# 12 Programmeurs zijn gek op computers en hebben weinig andere hobby’s.
table(participants_control$q12)
getmode(participants_control$q12)
median(participants_control$q12)
cor.test(participants_control$q12, participants_control$q5, method = "spearman")

# gender
table(participants_girls$q12)
table(participants_boys$q12)
cor.test(participants_girls$q12, participants_girls$q5, method = "spearman")
cor.test(participants_boys$q12, participants_boys$q5, method = "spearman")

# age
cor.test(participants_control$q12, participants_control$age)
cor.test(participants_age_7_8$q12, participants_age_7_8$q5, method = "spearman")
cor.test(participants_age_9_10$q12, participants_age_9_10$q5, method = "spearman")
cor.test(participants_age_11_12$q12, participants_age_11_12$q5, method = "spearman")
cor.test(participants_age_13_14$q12, participants_age_13_14$q5, method = "spearman")

# all 'grey'
# boys "#ffc107"
# girls"#004d40"))

table(participants_control$q2)

distributionPlot <- ggplot(participants_boys_exp_yes_school, aes(q5)) + 
  geom_histogram(binwidth = 1, colour= '#ffc107', fill='#ffc107') + 
  #scale_x_discrete(limits=c('1', '2', '3', '4', '5') ) +
  scale_x_continuous(breaks = seq(0, 6, 1)) +
  xlim(0,6) +
  theme_void() + 
  theme(axis.title.x = element_blank(), axis.text.x=element_blank(), axis.ticks.x=element_blank(), axis.text.y=element_blank(), axis.ticks.y=element_blank(), axis.title.y = element_blank() ) 

plot(distributionPlot)
#ggsave('distribution-q5-experience-school-boys.png', distributionPlot, width = 10, height = 6)

gender = subset(participants_control, !is.na(participants_control$gender_d))
social = subset(participants_control, !is.na(participants_control$social_d))
interest = subset(participants_control, !is.na(participants_control$interests_d))

range(participants_control$gender_d)
range(social$social_d)
range(interest$interests_d)

distributionPlot <- ggplot(gender, aes(gender_d)) + 
  geom_histogram(binwidth = 0.1, colour='grey', fill='gray88') + 
  scale_x_continuous(breaks = seq(-2, 2, 0.2)) +
  xlim(-2,2) +
  theme_void() + 
  theme(axis.title.x = element_blank(), axis.text.x=element_blank(), axis.ticks.x=element_blank(), axis.text.y=element_blank(), axis.ticks.y=element_blank(), axis.title.y = element_blank() ) 

plot(distributionPlot)
#ggsave('distribution-IAT-gender.png', distributionPlot, width = 10, height = 6)

rm(subset_q5_1, subset_q5_2, subset_q5_3, subset_q5_4, subset_q5_5)
rm(gender, interest, social)
rm(distributionPlot)